Type light
	Field entity
	Field typ
	Field r#,g#,b#,intensity#
	Field near#,far#,inner#,outer#
	Field active,shadows,infinite,overshoot
End Type

Const LIGHT_DIRECTIONAL = 1
Const LIGHT_OMNI		= 2
Const LIGHT_SPOT		= 3
Const LIGHT_AMBIENT		= 4

;
;
; ParseB3D
;
; Will scan through the names of an entity and all child entities
; and generate light types, and whatever custom stuff you add to it!
;
; Please note that this function is made for the example! You need
; to remove references to the emitter type, if you want to use it
; for your own projects!
;
Function ParseB3D(entity)

	If entity = 0 Then Return

	name$ = Replace(EntityName$(entity),Chr$(13),Chr$(10))
	
	;
	; Light properties
	If (Instr(name$,"[LIGHT]")<>0) And (Instr(name$,"[/LIGHT]")<>0)
	
		light.light = New light
		
		light\entity = entity
		
		; Light type	
		offset		= Instr(name$,"[LIGHT]",1)+8
		newoffset	= Instr(name$,Chr$(10),offset)
		typs$		= Mid$(name$,offset,newoffset-offset)
		Select typs
			Case "Directional": light\typ = LIGHT_DIRECTIONAL
			Case "Point": 		light\typ = LIGHT_OMNI
			Case "Spot": 		light\typ = LIGHT_SPOT
			Case "Ambient": 	light\typ = LIGHT_AMBIENT
		End Select
		
		; Red
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\r#	= Mid$(name$,offset,newoffset-offset)
		
		; Green
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\g#	= Mid$(name$,offset,newoffset-offset)
		
		; Blue
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\b#	= Mid$(name$,offset,newoffset-offset)

		; Intensity
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\intensity#	= Mid$(name$,offset,newoffset-offset)

		; Near Range
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\near#	= Mid$(name$,offset,newoffset-offset)

		; Far Range
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\far#	= Mid$(name$,offset,newoffset-offset)

		; Inner Cone
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\inner#	= Mid$(name$,offset,newoffset-offset)											

		; Outer Cone
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\outer#	= Mid$(name$,offset,newoffset-offset)

		; Active
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\active	= Mid$(name$,offset,newoffset-offset)

		; Cast Shadows
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\shadows	= Mid$(name$,offset,newoffset-offset)

		; Infinite
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\infinite	= Mid$(name$,offset,newoffset-offset)

		; Overshoot
		offset		= newoffset+1
		newoffset	= Instr(name$,Chr$(10),offset)
		light\overshoot	= Mid$(name$,offset,newoffset-offset)	
	End If	
	
	;
	; Custom properties
	If (Instr(name$,"[PROPS]")<>0) And (Instr(name$,"[/PROPS]")<>0)
		newoffset	= Instr(name$,"[PROPS]",1)+7
		
		; Uncomment this if you need it
		;
		;DebugLog "Custom properties for: "+Left$(name$,newoffset-9)
		
		emitter.emitter = Null
		
		Repeat
			;
			; Text offset for the next line
			offset		= newoffset+1
			newoffset	= Instr(name$,Chr$(10),offset)	
						
			;
			; The text on this line
			in$ = Mid$(name$,offset,newoffset-offset)
	
			; Jump out of the loop
			; at the end of the properties
			If in$ = "[/PROPS]"
				Exit
			End If
			
			;
			; Get the keyword
			key$ = ""
			offset = Instr(in$,"=")
			If offset
				key$		= Lower(Left$(in$,offset-1))
				content$	= Right$(in$,Len(in$)-offset)
			Else
				key$	= Lower(in)
			End If
			
			;
			; This is where you add your own stuff!
			; The things used in this example, are just that: examples
			; You can do anything!
			;
			Select key$
				Case "emittype":
					emitter.emitter = New emitter
					emitter\parent	= entity
					emitter\texture	= LoadTexture(GetCSV(content,1)+".bmp")

				Case "emitspeed":
					If Not (emitter = Null)
						emitter\speed = GetCSV(content,1)
					End If
					
				Case "emitspread":
					If Not (emitter = Null)
						emitter\spread = GetCSV(content,1)
					End If
					
				Case "emitlife":
					If Not (emitter = Null)
						emitter\life = GetCSV(content,1)
					End If
				
				Case "emitsize":
					If Not (emitter = Null)
						emitter\size = GetCSV(content,1)
					End If

				Case "emitblend":
					If Not (emitter = Null)
						emitter\blend = GetCSV(content,1)
					End If

				Case "emitrate":
					If Not (emitter = Null)
						emitter\rate = GetCSV(content,1)
					End If

				Case "emitgrowth":
					If Not (emitter = Null)
						emitter\growth = GetCSV(content,1)
					End If
				
				Case "emitgravity":
					If Not (emitter = Null)
						emitter\gravity = GetCSV(content,1)
					End If
					
				Case "moon":
					sprite = CreateSprite(entity)
					moontex = LoadTexture("skymoon.bmp")
					EntityTexture sprite,moontex
					EntityBlend sprite,3
					ScaleSprite sprite,200,200
																						
			End Select
			
			; Uncomment this to
			; print the property to the debug log
			; DebugLog "  Property: "+Chr$(34)+in$+Chr$(34)
	
		Forever
	End If
	
	;
	; Go through the children of this entity
	children = CountChildren(entity)
	For child = 1 To children
		ParseB3D(GetChild(entity,child))
	Next

End Function

;
; GetCSV$
;
; Returns the Nth comma seperated value from a string
; if the Nth value doesn't exist the last found value
; is returned
;
Function GetCSV$(in$,which=1)

	n = 1
	offset = 0
	nextoffset = 1
	While offset<Len(in$)
		nextoffset = Instr(in$,",",offset+1)
		If nextoffset = 0
			nextoffset = Len(in$)+1
			which = n
		End If
		valueret$ = Mid$(in$,offset+1,nextoffset-offset-1)
		If which = n	
			Return valueret	
		End If
		offset = nextoffset
		n=n+1
	Wend

	Return n-1

End Function